<?php
/**
 * Server-side rendering of the `core/cover` block.
 *
 * @package WordPress
 */

/**
 * Supports `playsinline` attribute server side for `core/cover`.
 *
 * @param array  $attributes The block attributes.
 * @param string $content HTML content of the block.
 *
 * @return string Rendered HTML of the referenced block.
 */
function gutenberg_render_block_core_cover( $attributes, $content ) {
	if ( isset( $attributes['backgroundType'] ) && 'video' === $attributes['backgroundType'] ) {
		return str_replace( 'autoplay muted', 'autoplay muted playsinline', $content );
	}

	return $content;
}

/**
 * Registers the `core/cover` block.
 */
function gutenberg_register_block_core_cover() {
	register_block_type_from_metadata(
		__DIR__ . '/cover',
		array(
			'render_callback' => 'gutenberg_render_block_core_cover',
		)
	);
}
add_action( 'init', 'gutenberg_register_block_core_cover', 20 );
